//=============================================================================
// forcezeroXP.js
//=============================================================================

/*:ja
 * @plugindesc ver1.00 xparamの拡張
 * @author まっつＵＰ
 * 
 * @param auto
 * @desc 名前に再生率とつかない追加能力値が
 * 0以下の場合強制的に0にする効果の有効化
 * @type boolean
 * @default true
 *
 * @help
 * 
 * RPGで笑顔を・・・
 * 
 * このヘルプとパラメータの説明をよくお読みになってからお使いください。
 * 
 * ステートのノートタグ
 * （以下ステートが付加されているバトラーへの効果です。）
 * 
 * <XPzero + xparamId>
 * 追加能力値のIDを指定することで
 * 計算上のその追加能力値が0を超える場合に
 * 追加能力値を0にします。
 * IDを+10して指定すると
 * 計算上のその追加能力値が0以下の場合に
 * 追加能力値を0にします。
 * 
 * <XPzero7>
 * HP再生率が計算上0を超えている場合に
 * HP再生率を0にします。
 * 
 * <XPzero18>
 * MP再生率が計算上0以下の場合に
 * MP再生率を0にします。
 * 
 * このプラグインを利用する場合は
 * readmeなどに「まっつＵＰ」の名を入れてください。
 * また、素材のみの販売はダメです。
 * 上記以外の規約等はございません。
 * もちろんツクールMVで使用する前提です。
 * 何か不具合ありましたら気軽にどうぞ。
 *  
 * 免責事項：
 * このプラグインを利用したことによるいかなる損害も制作者は一切の責任を負いません。
 * 
 */

(function() {

var parameters = PluginManager.parameters('forcezeroXP');
var XPauto = parameters['auto'] === 'true';

var XPtag = 'XPzero';

var _Game_Temp_initialize = Game_Temp.prototype.initialize;
Game_Temp.prototype.initialize = function() {
    _Game_Temp_initialize.call(this);
    this._XPallarray = {};
    var text;
    for(var i = 0; i < 20; i++){
        text = XPtag + i;
        this._XPallarray[text] = [];
        for(var j = 1; j < $dataStates.length; j++){
            if($dataStates[j].meta[text]){
                this._XPallarray[text].push(j);
            }
        }
    }
};

var _Game_BattlerBase_xparam = Game_BattlerBase.prototype.xparam;
Game_BattlerBase.prototype.xparam = function(xparamId) {
    var value = _Game_BattlerBase_xparam.call(this, xparamId);
    return this.XPforcezero(xparamId, value);
};

Game_BattlerBase.prototype.XPforcezero = function(paramId, value) {
    if(value <= 0){
        if(paramId < 7 && XPauto){
            return 0;
        }
        paramId += 10;
    }
    var text = XPtag + paramId;
    var force = $gameTemp._XPallarray[text].some(function(stateid) {
        return this.isStateAffected(stateid);
    }, this);
    if(force){
        return 0;
    }else{
        return value;
    }
};
 
})();
