//===============================================
// ResizeBattleBack.js 
//===============================================

/*:ja
 * @plugindesc 戦闘画面の背景に使用する画像をウィンドウのサイズに合わせます。
 * @author 村人A
 *
 * @help
 * _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/
 * 
 * バージョン情報
 * 
 * 2019/5/30 1.0リリース
 * 
 * _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/
 * 
 * ===================================
 * ヘルプ
 * ===================================
 * 
 * このプラグインは導入するだけで効果があります。
 * その他プラグインコマンドやパラメータはありません。
 * 
 */
 
(function() {
	'use strict';
	
	const _alias_Scene_Map_launchBattle = Scene_Map.prototype.launchBattle
	Scene_Map.prototype.launchBattle = function() {
		ImageManager.loadBattleback1(this.ori_bb_battleback1Name());
		ImageManager.loadBattleback2(this.ori_bb_battleback2Name());
		_alias_Scene_Map_launchBattle.call(this);
	};

	Scene_Map.prototype.ori_bb_battleback1Name = function() {
		if (BattleManager.isBattleTest()) {
			return $dataSystem.battleback1Name;
		} else if ($gameMap.battleback1Name()) {
			return $gameMap.battleback1Name();
		} else if ($gameMap.isOverworld()) {
			return this.ori_bb_overworldBattleback1Name();
		} else {
			return '';
		}
	};
	Scene_Map.prototype.ori_bb_battleback2Name = function() {
		if (BattleManager.isBattleTest()) {
			return $dataSystem.battleback2Name;
		} else if ($gameMap.battleback2Name()) {
			return $gameMap.battleback2Name();
		} else if ($gameMap.isOverworld()) {
			return this.ori_bb_overworldBattleback2Name();
		} else {
			return '';
		}
	};
	Scene_Map.prototype.ori_bb_overworldBattleback1Name = function() {
		if ($gamePlayer.isInVehicle()) {
			return Spriteset_Battle.prototype.shipBattleback1Name();
		} else {
			return this.ori_bb_normalBattleback1Name();
		}
	};
	Scene_Map.prototype.ori_bb_overworldBattleback2Name = function() {
		if ($gamePlayer.isInVehicle()) {
			return Spriteset_Battle.prototype.shipBattleback2Name();
		} else {
			return this.ori_bb_normalBattleback2Name();
		}
	};
	Scene_Map.prototype.ori_bb_normalBattleback1Name = function() {
		return (Spriteset_Battle.prototype.terrainBattleback1Name($gameMap.autotileType($gamePlayer.x, $gamePlayer.y, 1)) ||
				Spriteset_Battle.prototype.terrainBattleback1Name($gameMap.autotileType($gamePlayer.x, $gamePlayer.y, 0)) ||
				Spriteset_Battle.prototype.defaultBattleback1Name());
	};
	Scene_Map.prototype.ori_bb_normalBattleback2Name = function() {
		return (Spriteset_Battle.prototype.terrainBattleback2Name($gameMap.autotileType($gamePlayer.x, $gamePlayer.y, 1)) ||
				Spriteset_Battle.prototype.terrainBattleback2Name($gameMap.autotileType($gamePlayer.x, $gamePlayer.y, 0)) ||
				Spriteset_Battle.prototype.defaultBattleback2Name());
	};

	const _alias_Scene_Bootl_loadSystemImages = Scene_Boot.loadSystemImages
	Scene_Boot.loadSystemImages = function() {
		_alias_Scene_Bootl_loadSystemImages.call(this);
		ImageManager.loadBattleback1($dataSystem.battleback1Name);
		ImageManager.loadBattleback2($dataSystem.battleback2Name);
	}

	Spriteset_Battle.prototype.createBattleback = function() {
		this._back1Sprite = new Sprite();
		this._back2Sprite = new Sprite();
		this._back1Sprite.bitmap = new Bitmap(Graphics.width, Graphics.height);
		this._back2Sprite.bitmap = new Bitmap(Graphics.width, Graphics.height);
		const back1Bitmap = this.battleback1Bitmap();
		const back2Bitmap = this.battleback2Bitmap();
		this._back1Sprite.bitmap.blt(back1Bitmap, 0, 0, back1Bitmap.width, back1Bitmap.height, 0, 0, Graphics.width, Graphics.height);
		this._back2Sprite.bitmap.blt(back2Bitmap, 0, 0, back2Bitmap.width, back2Bitmap.height, 0, 0, Graphics.width, Graphics.height);
		this._battleField.addChild(this._back1Sprite);
		this._battleField.addChild(this._back2Sprite);
	};

	Spriteset_Battle.prototype.locateBattleback = function() {}

})();