//=============================================================================
// Mano_ActionForAll.js
// ----------------------------------------------------------------------------
// Copyright (c) 2017-2018 Sigureya
// This software is released under the MIT License.
// http://opensource.org/licenses/mit-license.php
// ----------------------------------------------------------------------------
// Version
// 1.0.0 2018/05/21 初版 
// ----------------------------------------------------------------------------
// [Twitter]: https://twitter.com/Sigureya/
//=============================================================================


/*:
 * @plugindesc スキルの一部の効果を拡張します。
 * 
 * @help
 * 効果ターンを延長したり、連続攻撃の回数を強化できます。
 * メモ欄に以下の改造を施すことで使えます。
 * 
 * ■書き方
 * <RepeatEX:10>
 * <RepeatEX:v[3]>
 * 
 * <StateTurnEX:3> 3ターン延長
 * <StateTurnEX:v[3]> 変数3で指定したターン延長
 * 右側の数値部分をevalして動かしています。
 * 
 */

(function(){
'use strict'

Game_BattlerBase.prototype.extensionStateCounts =function(stateId,turn){
    if(this._stateTurns[stateId]){
        this._stateTurns[stateId] =this._stateTurns[stateId]+turn;
    }    
};

const Game_Action_itemEffectAddNormalState =Game_Action.prototype.itemEffectAddNormalState;
/**
 * @param {Game_Battler} target 
 * @param {*} effect 
 */
Game_Action.prototype.itemEffectAddNormalState=function(target, effect){
    Game_Action_itemEffectAddNormalState.call(this,target, effect);
    const stateId = effect.dataId;
    const result = target.result();
    if(result.isStateAdded(stateId)){
        const exTurn = this.stateTurnExtends();
        if(exTurn !=0){
            target.extensionStateCounts(effect.dataId,exTurn );
        }
    }
};
Game_Action.prototype.stateTurnExtends =function(){
    return this.numberOrVariable_MA('StateTurnEX');
};

const Game_Action_numRepeats =Game_Action.prototype.numRepeats;
Game_Action.prototype.numRepeats =function(){
    const repeats= Game_Action_numRepeats.call(this);
    return repeats + this.extendsNumRepeats();
};

Game_Action.prototype.numberOrVariable_MA =function(metaKey){
    var item = this.item();
    const expr = item.meta[metaKey];
    if(!expr){
        return 0;
    }
    const a = this.subject();
    const v = $gameVariables._data;
    try {
        var value = eval(expr);
        if (isNaN(value)){
             return 0;
        }
		return value;
    } catch (e) {
        return 0;
    }
};

Game_Action.prototype.extendsNumRepeats=function(){
    return this.numberOrVariable_MA("RepeatEX");
};

})()
