//=============================================================================
// FlontAnimposi.js
//=============================================================================

/*:ja
 * @plugindesc ver1.00 フロントビューでのアニメ位置を調整
 * @author まっつＵＰ
 * 
 * @param dummyX
 * @desc アニメ表示のx座標の基準（0未満可）
 * @type number
 * @min -1600
 * @max 1600
 * @default 408
 * 
 * @param dummyY
 * @desc アニメ表示のy座標の基準（0未満可）
 * @type number
 * @min -1200
 * @max 1200
 * @default 312
 * 
 * @param dummyX2
 * @desc アニメ表示のx座標の
 * アクターのindexによる補正（0未満可）
 * @type number
 * @min -1200
 * @max 1200
 * @default 0
 * 
 * @param dummyY2
 * @desc アニメ表示のy座標の
 * アクターのindexによる補正（0未満可）
 * @type number
 * @min -1200
 * @max 1200
 * @default 0
 *
 * @help
 * 
 * RPGで笑顔を・・・
 * 
 * このヘルプとパラメータの説明をよくお読みになってからお使いください。
 * 
 * フロントビュー選択時、
 * サイドビューアクターの基本の位置を指定位置に変更し
 * その位置にアニメーションを表示させます。
 * 
 * このプラグインを利用する場合は
 * readmeなどに「まっつＵＰ」の名を入れてください。
 * また、素材のみの販売はダメです。
 * 上記以外の規約等はございません。
 * もちろんツクールMVで使用する前提です。
 * 何か不具合ありましたら気軽にどうぞ。
 *  
 * 免責事項：
 * このプラグインを利用したことによるいかなる損害も制作者は一切の責任を負いません。
 * 
 */

(function() {
    
var parameters = PluginManager.parameters('FlontAnimposi');
var FAdummyX = Number(parameters['dummyX']);
var FAdummyY = Number(parameters['dummyY']);
var FAdummyX2 = Number(parameters['dummyX2']);
var FAdummyY2 = Number(parameters['dummyY2']);

var _Sprite_Actor_setActorHome = Sprite_Actor.prototype.setActorHome;
Sprite_Actor.prototype.setActorHome = function(index) {
    if(!$gameSystem.isSideView()){
        this.setHome(FAdummyX + index * FAdummyX2, FAdummyY + index * FAdummyY2);
    }else{
        _Sprite_Actor_setActorHome.call(this, index);
    }
};

var _Sprite_Battler_setupAnimation = Sprite_Battler.prototype.setupAnimation;
Sprite_Battler.prototype.setupAnimation = function() {
    if(!$gameSystem.isSideView()){
        while (this._battler.isAnimationRequested()) {
            var data = this._battler.shiftAnimation();
            var animation = $dataAnimations[data.animationId];
            var mirror = data.mirror;
            var delay = animation.position === 3 ? 0 : data.delay;
            this.startAnimation(animation, mirror, delay);
        }
    }else{
        _Sprite_Battler_setupAnimation.call(this);
    }
};
 
})();
