//===============================================
// ActorsVoiceVolume.js 
//===============================================

/*:ja
 * @plugindesc アクターごとのボイスを設定し、その音量を設定できるようにするプラグインです。
 * @author 村人A
 *
 * @help
 * _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/
 * 
 * バージョン情報
 * 
 * 2020/03/15 1.1リリース
 * コンティニューした際にメタタグが記述されていないアクターが表示される不具合を修正しました。
 * 
 * 2019/10/12 1.0リリース
 * 2番以降や番号を飛ばしてアクターにボイスを設定した場合発生する不具合を修正しま
 * した。
 * 
 * 2019/09/30 0.9リリース
 * 
 * _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/
 * 
 * ===================================
 * ヘルプ
 * ===================================
 * 
 * アクターのメモ欄に
 * 
 * <useVoice:ボイスファイル名,ボイスファイル名,ボイスファイル名…>
 * 
 * と記述することでオプション画面にアクターの声の音量を指定できる項目が追加され
 * ます。
 * そこで設定した音量で<useVoice:…>にて指定した音声ファイルを再生します。
 * 
 * 
 * 
 * 
 */

(function() {
	'use strict';
	
	//AudioManager.actorVoiceVolume = [100,100,100,100,100];
	
	//-----------------------------------------------------------------------------
	// AudioManager
	//

	const _alias_AudioManager_playSe = AudioManager.playSe
	AudioManager.playSe = function(se) {
		if(!se.name) {return}
		this.actorVoiceIndex = 0;
		for(let i = 1; i < $gameActors.actorsVoices.length; i++){
			const arr = $gameActors.actorsVoices[i]
			if(!arr){continue}
			if(arr.indexOf(se.name) >= 0){
				this.actorVoiceIndex = i;
				break;
			}
		}
		_alias_AudioManager_playSe.call(this, se);
	};

	const _alias_AudioManager_updateSeParameters = AudioManager.updateSeParameters
	AudioManager.updateSeParameters = function(buffer, se) {
		if(this.actorVoiceIndex > 0){
			const volume = AudioManager.actorVoiceVolume[this.actorVoiceIndex]
			this.updateBufferParameters(buffer, volume, se);
		} else {
			_alias_AudioManager_updateSeParameters.call(this, buffer, se);
		}
		this.actorVoiceIndex = 0;
	};
		
	//-----------------------------------------------------------------------------
	// ConfigManager
	//

	Object.defineProperty(ConfigManager, 'actorVoiceVolume', {
		get: function() {
			return AudioManager.actorVoiceVolume;
		},
		set: function(value) {
			AudioManager.actorVoiceVolume = value;
		},
		configurable: true
	});

	const _alias_ConfigManager_makeData = ConfigManager.makeData;
	ConfigManager.makeData = function() {
		const config = _alias_ConfigManager_makeData.call(this);
		config.actorVoiceVolume = this.actorVoiceVolume;
		return config;
	};

	const _alias_ConfigManager_applyData = ConfigManager.applyData;
	ConfigManager.applyData = function(config) {
		_alias_ConfigManager_applyData.call(this, config);
		this.actorVoiceVolume = this.readVolume(config, 'actorVoiceVolume');
	};
	
	const _alias_ConfigManager_readVolume = ConfigManager.readVolume;
	ConfigManager.readVolume = function(config, name) {
		if(name == 'actorVoiceVolume'){
			let array = config[name];
			if (array !== undefined) {
				array = array.map(function(value){return Number(value).clamp(0, 100)});
				return array;
			} else {
				return null;
			}
		} else {
			return _alias_ConfigManager_readVolume.call(this, config, name);
		}
	};

	//-----------------------------------------------------------------------------
	// Game_Actors
	//

	const _alias_Game_Actors_initialize = Game_Actors.prototype.initialize;
	Game_Actors.prototype.initialize = function() {
		_alias_Game_Actors_initialize.call(this);
		this.actorsVoices =　$dataActors.map(function(actor){try{return actor.meta.useVoice.split(',')}catch(e){return undefined}});
		if(ConfigManager.actorVoiceVolume){return};
		ConfigManager.actorVoiceVolume = [];
		for(let i = 0; i < this.actorsVoices.length; i++){
			AudioManager.actorVoiceVolume.push(100)
		};
	}

	//-----------------------------------------------------------------------------
	// Window_Options
	//

	const _alias_Window_Options_makeCommandList = Window_Options.prototype.makeCommandList;
	Window_Options.prototype.makeCommandList = function() {
		_alias_Window_Options_makeCommandList.call(this);
		this.addVoiceVolumeOptions();
	}

	Window_Options.prototype.addVoiceVolumeOptions = function() {
		this.preListMaxNum = this._list.length;
		for(let i = 1; i < $gameActors.actorsVoices.length; i++){
			if(!$gameActors.actorsVoices[i]){continue};
			const label = $gameActors.actor(i).name() + "のボイス音量";
			const marker = "actorVoiceVolume" + i;
			this.addCommand(label, marker);
		}
	};

	const _alias_Window_Options_getConfigValue = Window_Options.prototype.getConfigValue;
	Window_Options.prototype.getConfigValue = function(symbol) {
		if(symbol == "actorVoiceVolume"){
			return ConfigManager[symbol][this.actorVoiceVolumeValue]
		} else {
			return _alias_Window_Options_getConfigValue.call(this, symbol);
		}
	};

	Window_Options.prototype.commandSymbol = function(index) {
		const tempSymbol = this._list[index].symbol;
		const res = tempSymbol.match(/actorVoiceVolume(\d+)/)
		if(res){
			this.actorCommandIndex = index;
			this.actorVoiceVolumeValue = Number(res[1])
			return "actorVoiceVolume"
		} else {
			return tempSymbol
		}
	};
	
	const _alias_Window_Options_setConfigValue = Window_Options.prototype.setConfigValue;
	Window_Options.prototype.setConfigValue = function(symbol, volume) {
		if(symbol == "actorVoiceVolume"){
			ConfigManager[symbol][this.actorVoiceVolumeValue] = volume;
		} else {
			_alias_Window_Options_setConfigValue.call(this, symbol, volume);
		}
	};

	const _alias_Window_Options_findSymbol = Window_Options.prototype.findSymbol;
	Window_Options.prototype.findSymbol = function(symbol) {
		if(symbol == "actorVoiceVolume"){
			return this.actorCommandIndex;
		} else {
			return _alias_Window_Options_findSymbol.call(this, symbol);
		}
	};

})();