 (function(){
    'use strict';

    // 以下にカスタマイズ用コードを貼りつけ
      // パーティに追加を表示
    var addCommandName = '追加';
    var _Window_PartyChangeFront_drawItem = Window_PartyChangeFront.prototype.drawItem;
    Window_PartyChangeFront.prototype.drawItem = function(index) {
        var iconAddId = 1443;
	    _Window_PartyChangeFront_drawItem.apply(this, arguments);
	    if(this._list[index] == null){
	        var rect = this.itemRect(index);
	        this.changePaintOpacity(this._listEnabled[index]);
	        this.drawIcon(iconAddId, rect.x + 5, rect.y);
	        this.drawText(addCommandName, rect.x + Window_Base._iconWidth + wd_front_charaview_x, rect.y, rect.width);
	    }
    };

    // パーティ人数がいっぱいでもパーティに追加コマンドを表示する
    var _Window_PartyChangeFront_refresh = Window_PartyChangeFront.prototype.refresh;
    Window_PartyChangeFront.prototype.refresh = function() {
	_Window_PartyChangeFront_refresh.apply(this);
	
        if($gameParty.members().length >= wd_party_max){
            this._list.push(null);
            this._listEnabled.push(false); 
        }

        this.createContents();
        this.drawAllItems();
    };

    // パーティからはずすを表示
    var removeCommandName = '待機';
    var _Window_PartyChangeBack_drawItem = Window_PartyChangeBack.prototype.drawItem;
    Window_PartyChangeBack.prototype.drawItem = function(index) {
        var iconRemoveId = 1453;
	_Window_PartyChangeBack_drawItem.call(this, index);
	
	if(this._list[index] == null){
	    var rect = this.itemRect(index);
	    this.changePaintOpacity(this._listEnabled[index]);
	    this.drawIcon(iconRemoveId, rect.x + 5, rect.y);
	    this.drawText(removeCommandName, rect.x + Window_Base._iconWidth + wd_front_charaview_x, rect.y, rect.width, 'left');
	}
    };

    var _Window_PartyChangeBack_refresh = Window_PartyChangeBack.prototype.refresh;
    Window_PartyChangeBack.prototype.refresh = function() {
	_Window_PartyChangeBack_refresh.call(this);	

	// パーティに参加しているメンバーを非表示
	for(var i = this._list.length - 1; i >= 0; i-- ){
	    if(isPartyMember(this._list[i])){
		this._list.splice(i, 1);
		this._listEnabled.splice(i, 1);
	    }
	}

	// メンバーが1人の時にパーティからはずすコマンドをグレーで表示
	if($gameParty.members().length === 1){
	    this._list.push(null);
	    this._listEnabled.push(false);
	}

	this.createContents();
	this.drawAllItems();
    };


    // パーティに入っているか
    function isPartyMember(actor){
	for(var i = 0; i < $gameParty.members().length;i++ ){
	    if(actor === $gameParty.members()[i]){
		return true;
	    }
	}

	return false;
    }


    //メンバーリストのカーソルをアクティブ時のみ表示 
    var _Window_PartyChangeBack_initialize = Window_PartyChangeBack.prototype.initialize;
    Window_PartyChangeBack.prototype.initialize = function(mode) {
	_Window_PartyChangeBack_initialize.call(this, mode);
	this.deselect();
    };

    var _Scene_PartyChange_frontOk = Scene_PartyChange.prototype.frontOk;
    Scene_PartyChange.prototype.frontOk = function() {
	_Scene_PartyChange_frontOk.call(this);
	this._backWindow.select(0);
    };

    var _Scene_PartyChange_backOk = Scene_PartyChange.prototype.backOk;
    Scene_PartyChange.prototype.backOk = function() {
	_Scene_PartyChange_backOk.call(this);
	this._backWindow.deselect();

    var _Scene_PartyChange_backCancel = Scene_PartyChange.prototype.backCancel;
      Scene_PartyChange.prototype.backCancel = function() {
	  _Scene_PartyChange_backCancel.call(this);
	  this._backWindow.deselect();	  
      };
    };

/*    Window_PartyChangeStatus.prototype.drawActorEquipments = function(actor, x, y) {
	var slotNameWidth = 100;
	
        var equips = actor.equips();
        var count = Math.min(equips.length, 6);
        for (var i = 0; i < count; i++) {
	    this.changeTextColor(this.systemColor());
	    this.drawText(getSlotName(actor.equipSlots()[i]), x, y + this.lineHeight() * i, slotNameWidth);
	    this.resetTextColor();
	    
            this.drawItemName(equips[i], x + slotNameWidth, y + this.lineHeight() * i);
        }
    };

    // 装備部位名を取得
    function getSlotName(slotId){
	return $dataSystem.equipTypes[slotId];
    }*/


  })();