﻿//===============================================
// ShowActorSkillAnimation.js 
//===============================================

/*:ja
 * @plugindesc フロントビュー戦闘でアクターへのスキルのアニメーション・ダメージホップアップを表示するプラグインです。
 * @author 村人A
 *
 * @help
 * _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/
 * 
 * バージョン情報
 * 
 * 2020/02/18 1.02リリース
 * パーティー4人のそれぞれのアニメーション＆ダメージの位置を表示できるようにしました。
 * 
 * 2019/06/01 1.00リリース
 * 
 * _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/
 * 
 * ===================================
 * ヘルプ
 * ===================================
 * 
 * フロントビューのアクターへのスキルアニメーションとダメージホップアップを任意の場所に表示します。
 * アニメーションの表示ダメージホップアップの表示・非表示はプラグインパラメータにて設定可能です。
 * また、位置についてもプラグインパラメータにて設定できます。
 * 
 * @param アニメーションの表示
 * @desc サイドビュー戦闘でない時に敵の攻撃のアニメーションを表示するかどうか
 * @default true
 * @type boolean
 * 
 * @param ダメージホップアップの表示
 * @desc サイドビュー戦闘でない時に敵の攻撃のダメージホップアップ表示するかどうか
 * @default true
 * @type boolean
 * 
 * @param ウィンドウより手前に表示するか
 * @desc アニメーションとダメージホップアップをウィンドウの手前に表示するかどうか
 * @default true
 * @type boolean
 * 
 * @param 画面対象の戦闘アニメーションの位置
 * @desc 敵からの攻撃でない画面対象の戦闘アニメーションの位置を中心と同じにするか画面中央に持ってくるかを指定します。trueで中心と同じ位置になります。
 * @default true
 * @type boolean
 * 
 * @param 以下ニメーション＆ダメージホップアップの位置
 * @desc サイドビュー戦闘でない時のアニメーションとダメージホップアップを表示する位置を半角カンマ,を挟んでx座標,y座標で指定します。
 * @default ―――――――――――――――――――――――
 * 
 * @param メンバー1の位置
 * @desc メンバー1のアニメーションとダメージホップアップを表示する位置を半角カンマ,を挟んでx座標,y座標で指定します。
 * @default 100,600
 * 
 * @param メンバー2の位置
 * @desc メンバー２のアニメーションとダメージホップアップを表示する位置を半角カンマ,を挟んでx座標,y座標で指定します。
 * @default 300,600
 * 
 * @param メンバー3の位置
 * @desc メンバー３のアニメーションとダメージホップアップを表示する位置を半角カンマ,を挟んでx座標,y座標で指定します。
 * @default 500,600
 * 
 * @param メンバー4の位置
 * @desc メンバー４のアニメーションとダメージホップアップを表示する位置を半角カンマ,を挟んでx座標,y座標で指定します。
 * @default 700,600
 * 
 * @param 画面対象アニメーションの位置
 * @desc アニメーションの位置が画面だった場合の位置を半角カンマ,を挟んでx座標,y座標で指定します。
 * @default 400,300
 * 
 * 
 */
 
(function() {
	'use strict';
	
	String.prototype.toNumArray = function() {
		return this.split(',').map(function(str){return Number(str)});
	}
	
    let parameters = PluginManager.parameters('ShowActorSkillAnimation');
	const isShowAnimation   = parameters['アニメーションの表示'] == 'true';
	const isShowDamageHopup = parameters['ダメージホップアップの表示'] == 'true';
	const isShowFrontOfWindow = parameters['ウィンドウより手前に表示するか'] == 'true';
	const commonScreenAnimationPos = parameters['画面対象の戦闘アニメーションの位置'] == 'true';
	let animationPosition = []
	for(let i = 1; i < 5; i++){
		const str ='メンバー' + i +'の位置';
		animationPosition.push(parameters[str].toNumArray());
	}
	const screenAnimationPos = parameters['画面対象アニメーションの位置'].toNumArray();
	
	//-----------------------------------------------------------------------------
	// Game_Interpreter
	//
	
	const _alias_Game_Interpreter_command337 = Game_Interpreter.prototype.command337;
	Game_Interpreter.prototype.command337 = function() {
		$gameSystem.isBattleEventAnimation = true;
		return _alias_Game_Interpreter_command337.call(this);
	}
	
	//-----------------------------------------------------------------------------
	// Scene_Battle
	//
	
	const _alias_Scene_Battle_createDisplayObjects = Scene_Battle.prototype.createDisplayObjects;
	Scene_Battle.prototype.createDisplayObjects = function() {
		_alias_Scene_Battle_createDisplayObjects.call(this);
		this._spriteset.createAnimationLayer();
	}
	
	//-----------------------------------------------------------------------------
	// Spriteset_Battle
	//
	
	Spriteset_Battle.prototype.createAnimationLayer = function() {
		if(!$gameSystem.isSideView() && isShowFrontOfWindow){
			this._actorSprites = [];
			for (var i = 0; i < $gameParty.maxBattleMembers(); i++) {
				this._actorSprites[i] = new Sprite_Actor();
				this.parent.addChild(this._actorSprites[i]);
			}
		}
	}
	
	const _alias_Spriteset_Battle_createActors = Spriteset_Battle.prototype.createActors;
	Spriteset_Battle.prototype.createActors = function() {
		if(!$gameSystem.isSideView() && isShowFrontOfWindow){
			this._actorSprites = [];
			for (var i = 0; i < $gameParty.maxBattleMembers(); i++) {
				this._actorSprites[i] = new Sprite_Actor();
				this._battleField.addChild(this._actorSprites[i]);
			}
		} else {
			_alias_Spriteset_Battle_createActors.call(this);
		}
	};

	//-----------------------------------------------------------------------------
	// Sprite_Base
	//
	
	const _alias_Sprite_Base_startAnimation = Sprite_Base.prototype.startAnimation;
	Sprite_Base.prototype.startAnimation = function(animation, mirror, delay) {
		_alias_Sprite_Base_startAnimation.call(this, animation, mirror, delay);
		this._animationSprites[this._animationSprites.length-1].checkBattleEventAnimation();
		$gameSystem.isBattleEventAnimation = false;
	};

	//-----------------------------------------------------------------------------
	// Sprite_Actor
	//
	
	const _alias_Sprite_Actor_setActorHome = Sprite_Actor.prototype.setActorHome;
	Sprite_Actor.prototype.setActorHome = function(index) {
		if($gameSystem.isSideView()){
			_alias_Sprite_Actor_setActorHome.call(this, index)
		} else {
			const pos = animationPosition[index];
			this.setHome(pos[0], pos[1]);
		}
	};

	//-----------------------------------------------------------------------------
	// Sprite_Animation
	//
	
	Sprite_Animation.prototype.checkBattleEventAnimation = function() {
		if($gameSystem.isBattleEventAnimation){
			this.battleEventAnimation = true;
		}
	}
	
	const _alias_Sprite_Animation_remove = Sprite_Animation.prototype.remove;
	Sprite_Animation.prototype.remove = function() {
		_alias_Sprite_Animation_remove.call(this);
		this.battleEventAnimation = false;
	}
	
	const _alias_Sprite_Animation_updatePosition = Sprite_Animation.prototype.updatePosition;
	Sprite_Animation.prototype.updatePosition = function() {
		if (this._animation.position === 3) {
			if($gameParty.inBattle() && !this.battleEventAnimation && BattleManager._targets[0].isActor()){
				this.x = screenAnimationPos[0];
				this.y = screenAnimationPos[1];
			} else {
				if(commonScreenAnimationPos){
					this._animation.position = 1;
				} else {
					this.x = Graphics.width / 2;
					this.y = Graphics.height / 2;
				}
			}
		} else {
			_alias_Sprite_Animation_updatePosition.call(this);
		}
	}

	//-----------------------------------------------------------------------------
	// Sprite_Battler
	//
	
	const _alias_Sprite_Battler_setupAnimation = Sprite_Battler.prototype.setupAnimation;
	Sprite_Battler.prototype.setupAnimation = function() {
		if($gameSystem.isSideView()){
			_alias_Sprite_Battler_setupAnimation.call(this);
		} else {
			while (this._battler.isAnimationRequested()) {
				const data = this._battler.shiftAnimation();
				const animation = $dataAnimations[data.animationId];
				const mirror = data.mirror;
				const delay = animation.position === 3 ? 0 : data.delay;
				this.startAnimation(animation, mirror, delay);
				for (let i = 0; i < this._animationSprites.length; i++) {
					const sprite = this._animationSprites[i];
					sprite.visible = isShowAnimation;
				}
			}
		}
	};
	
	const _alias_Sprite_Battler_setupDamagePopup = Sprite_Battler.prototype.setupDamagePopup;
	Sprite_Battler.prototype.setupDamagePopup = function() {
		if (this._battler.isDamagePopupRequested()) {
			if($gameSystem.isSideView()){
				_alias_Sprite_Battler_setupDamagePopup.call(this);
			} else {
				if(isShowDamageHopup){
					const sprite = new Sprite_Damage();
					sprite.x = this.x + this.damageOffsetX();
					sprite.y = this.y + this.damageOffsetY();
					sprite.setup(this._battler);
					this._damages.push(sprite);
					this.parent.addChild(sprite);
				}
				this._battler.clearDamagePopup();
				this._battler.clearResult();
			}
		}
	};
})();