﻿# Protection 
#「対象選択式かばう」                                  (作成日……2017/ 7/ 5)
#______________________________________________________________________________

=begin

  常時発動型ではなく対象選択方式の「身代わり」機能を実装します。
  ステート（特徴）ではなくスキル（内部フラグ）による「身代わり」機能です。

  スキルのメモ欄に、 <protect> または <かばう> ……と書くと、
  選択式「かばう」専用スキルになります。

 「身代わり」の対象は、スキルの「効果範囲」がそのまま適用されます。
 「味方単体」を設定すれば、ルドラの秘宝の「ぼうぎょ」仕様、
 「味方全体」を設定すれば、FFXの「かばう」および「鉄壁」仕様になります。

 「身代わり」効果が発揮されるのは使用したターン内のみです。
  基本的には「防御」などと同様に速度補正を設定すること。
  他の設定項目も「防御」に準じたもの（「なし」）にしておくと良いでしょう。

  なお、「ダメージ効果」や「使用効果」を設定した場合、
  通常のスキルと同様に効果が発揮されます。
 「防御」ステートや「かばう」ステートの付加は不要です。

=end
#______________________________________________________________________________

module Protection
  FOR_ALL    = false   # 全体攻撃をかばうか否か
  FOR_FRIEND = false   # 味方対象の行動に対してかばうか否か

  CERTAIN    = false   # 命中タイプ「必中」の攻撃をかばうか否か
  PHYSICAL   = true    # 命中タイプ「物理」の攻撃をかばうか否か
  MAGICAL    = false   # 命中タイプ「魔法」の攻撃をかばうか否か

  GUARDING   = true    #「かばう」実行時に「防御」フラグをオンにするか
  NO_EVADE   = true    #「かばう」実行時の回避率を 0 にするか
end
#______________________________________________________________________________


class RPG::UsableItem < RPG::BaseItem
  def protect?
    return false
  end
end
class RPG::Skill < RPG::UsableItem
  def protect?
    @__protect = (/<(?:protect|かばう)>/i =~ note)  if @__protect == nil
    return @__protect
  end
end
#______________________________________________________________________________

class Game_Battler < Game_BattlerBase
  attr_accessor :protected_battlers       #「かばう」対象の配列

  alias protection__initialize  initialize
  def initialize
    @protected_battlers = []

    protection__initialize
  end
  #--------------------------------------------------------------------------
  def protecting?
    return !@protected_battlers.empty?
  end
  #--------------------------------------------------------------------------
  def protectable?(target, item)
    return false  if target == self

    return false  if item.for_all?      unless Protection::FOR_ALL
    return false  if item.for_friend?   unless Protection::FOR_FRIEND
    return false  if item.certain?      unless Protection::CERTAIN
    return false  if item.physical?     unless Protection::PHYSICAL
    return false  if item.magical?      unless Protection::MAGICAL

    return movable? && @protected_battlers.include?(target)
  end
  #--------------------------------------------------------------------------
  if Protection::GUARDING
  def guard?  # Game_Battler オーバーライド
    super or (movable? && protecting?)
  end
  end
  #--------------------------------------------------------------------------
  if Protection::NO_EVADE
  alias protection__item_eva  item_eva
  def item_eva(user, item)
    protecting? ?  0 : protection__item_eva(user, item)
  end
  end
  #--------------------------------------------------------------------------
  alias protection__on_restrict  on_restrict
  def on_restrict
    @protected_battlers.clear

    protection__on_restrict
  end
  #--------------------------------------------------------------------------
  alias protection__item_user_effect  item_user_effect
  def item_user_effect(user, item)

    if item.protect?
      user.protected_battlers.push(self)
      @result.success = true               #「効かなかった！」を表示しない
    end

    protection__item_user_effect(user, item)
  end
  #--------------------------------------------------------------------------
  alias protection__on_turn_end  on_turn_end
  def on_turn_end
    @protected_battlers.clear

    protection__on_turn_end
  end
  #--------------------------------------------------------------------------
  alias protection__on_battle_end  on_battle_end
  def on_battle_end
    @protected_battlers.clear

    protection__on_battle_end
  end
end

class Game_Unit
  def protecting_battler(target, item)
    members.find{|member| member.protectable?(target, item) }
  end
end

class Scene_Battle < Scene_Base
  #--------------------------------------------------------------------------
  # ● 身代わりの適用
  #--------------------------------------------------------------------------
  alias protection__apply_substitute  apply_substitute
  def apply_substitute(target, item)

    substitute = target.friends_unit.protecting_battler(target, item)
    if substitute
      @log_window.display_substitute(substitute, target)
      return substitute
    end

    # デフォルトの「身代わり」処理
    return protection__apply_substitute(target, item)
  end
end
