//=============================================================================
// Pon_MenuPcture.js
//=============================================================================
/*:
 * @plugindesc メニューにピクチャを追加します。
 * @author ぽんぽこねるそん
 
 * @help  
 *<説明>
 *
 *1.メニュー等の画面の背景・メニュー・アイテム・スキル画面の
 *    アクター選択ウィンドウにピクチャを追加します。
 *
 *2.メニュー・アイテム・スキル画面のアクター選択ウィンドウの
 *    アクターの顔グラの代わりに
 *    アクターに設定したピクチャを描画します。
 *
 *<使い方>
 *右のパラメータの設定を行ってください。
 *
 *アクターのメモ欄に<PonMenuStandPicture:filename>と
 *記述すると顔グラの代わりにそのファイル名がfilenameのピクチャを描画します。
 *ex.Actor_1_1という画像を設定する場合  <PonMenuStandPicture:Actor_1_1>
 *
 *各種画像は下記のプラグインコマンドで変更できます。
 *※画像ファイルはimgフォルダ内のpicturesフォルダに入れてください。
 *※手抜き仕様で座標の調整等はできないので画像の方を調整してください。
 *
 *<プラグインコマンド>
 *PonChangeBackPicture filename
 *  メニュー等の画面の背景の追加ピクチャをfilenameにします。
 *    filenameを指定しなければ画像を消すことができます。
 *    ex.Actor_1_1という画像を設定する場合  PonChangeBackPicture Actor_1_1
 *
 *PonChangeWinowPicture filename
 *  アクター選択ウィンドウの追加ピクチャをfilenameにします。
 *    filenameを指定しなければ画像を消すことができます。
 *    ex.Actor_1_1という画像を設定する場合  PonChangeWinowPicture Actor_1_1
 *
 *PonChangeActorMenuPic actor_id filename
 *  actor_id番のアクターの顔グラの代わりのピクチャをfilenameにします。
 *    filenameを指定しなければ画像を消すことができます。
 *    ex.アクター1番のピクチャをActor_1_1という画像に設定する場合  
 *       PonChangeActorMenuPic 1 Actor_1_1
 *
 * @param Back Picture Name
 * @desc 画面の背景に表示するピクチャのファイル名です。
 * 空白にすると表示しません。(拡張子は不要です)
 * @default 
 * @param Window Picture Name
 * @desc アクター選択ウィンドウに表示するピクチャのファイル名です。
 * 空白にすると表示しません。(拡張子は不要です)
 * @default 
 *
 * @param Menu Back Picture
 * @type boolean
 * @on 追加する
 * @off 追加しない
 * @desc メニュー画面の背景にピクチャを追加するかの設定です。 
 * @default true
 *
 * @param Item Back Picture
 * @type boolean
 * @on 追加する
 * @off 追加しない
 * @desc アイテム画面の背景にピクチャを追加するかの設定です。 
 * @default true
 *
 * @param Skill Back Picture
 * @type boolean
 * @on 追加する
 * @off 追加しない
 * @desc スキル画面の背景にピクチャを追加するかの設定です。 
 * @default true
 *
 * @param Equip Back Picture
 * @type boolean
 * @on 追加する
 * @off 追加しない
 * @desc 装備画面の背景にピクチャを追加するかの設定です。 
 * @default true
 *
 * @param Status Back Picture
 * @type boolean
 * @on 追加する
 * @off 追加しない
 * @desc ステータス画面の背景にピクチャを追加するかの設定です。 
 * @default true
 *
 * @param Save Back Picture
 * @type boolean
 * @on 追加する
 * @off 追加しない
 * @desc セーブ画面の背景にピクチャを追加するかの設定です。 
 * @default true
 *
 * @param End Back Picture
 * @type boolean
 * @on 追加する
 * @off 追加しない
 * @desc 終了画面の背景にピクチャを追加するかの設定です。 
 * @default true
 *
 * @param Option Back Picture
 * @type boolean
 * @on 追加する
 * @off 追加しない
 * @desc オプション画面の背景にピクチャを追加するかの設定です。 
 *タイトル画面でも表示されてしまうのでしないを推奨
 * @default false
 */

var Liquidize = Liquidize || {};
Liquidize.Pon_MenuiPcture = {};
Liquidize.Pon_MenuiPcture.Parameters = PluginManager.parameters('Pon_MenuPcture');
Liquidize.Pon_MenuiPctureBackPictureName = String(Liquidize.Pon_MenuiPcture.Parameters["Back Picture Name"] || '');
Liquidize.Pon_MenuiPctureWindowPictureName = String(Liquidize.Pon_MenuiPcture.Parameters["Window Picture Name"] || '');
Liquidize.Pon_MenuiPcture.MenuBackPicture = JSON.parse(Liquidize.Pon_MenuiPcture.Parameters["Menu Back Picture"]);
Liquidize.Pon_MenuiPcture.ItemBackPicture = JSON.parse(Liquidize.Pon_MenuiPcture.Parameters["Item Back Picture"]);
Liquidize.Pon_MenuiPcture.SkillBackPicture = JSON.parse(Liquidize.Pon_MenuiPcture.Parameters["Skill Back Picture"]);
Liquidize.Pon_MenuiPcture.EquipBackPicture = JSON.parse(Liquidize.Pon_MenuiPcture.Parameters["Equip Back Picture"]);
Liquidize.Pon_MenuiPcture.StatusBackPicture = JSON.parse(Liquidize.Pon_MenuiPcture.Parameters["Status Back Picture"]);
Liquidize.Pon_MenuiPcture.SaveBackPicture = JSON.parse(Liquidize.Pon_MenuiPcture.Parameters["Save Back Picture"]);
Liquidize.Pon_MenuiPcture.EndBackPicture = JSON.parse(Liquidize.Pon_MenuiPcture.Parameters["End Back Picture"]);
Liquidize.Pon_MenuiPcture.OptionBackPicture = JSON.parse(Liquidize.Pon_MenuiPcture.Parameters["Option Back Picture"]);

(function() {
	
	//=============================================================================
	// プラグインコマンドの追加
	//=============================================================================
	var _Game_Interpreter_pluginCommand =
            Game_Interpreter.prototype.pluginCommand;
    Game_Interpreter.prototype.pluginCommand = function(command, args) {
        _Game_Interpreter_pluginCommand.call(this, command, args);
        if (command === 'PonChangeBackPicture') {
        	$gameSystem._backPictureName = String(args[0] || '');
        }
        if (command === 'PonChangeWinowPicture') {
        	$gameSystem._windowPictureName = String(args[0] || '');
        }
        if (command === 'PonChangeActorMenuPic') {
        	var actor =  $gameActors.actor(args[0])
        	if (!actor) {return};
        	actor.changeMenuStandPicture(String(args[1] || ''));
        }
    };
	//=============================================================================
	// システムに画面背景とアクター選択ウィンドウ背景のピクチャ名の追加
	//=============================================================================
    var _pon_gamesysteminitialize = Game_System.prototype.initialize;
    Game_System.prototype.initialize = function() {
        _pon_gamesysteminitialize.call(this);
        this.initBackPictureName();
        this.initWindowPictureName();
    };
	//=============================================================================
	// 画面背景の初期化
	//=============================================================================
    Game_System.prototype.initBackPictureName = function() {
        this._backPictureName = Liquidize.Pon_MenuiPctureBackPictureName
    };
	//=============================================================================
	// 画面背景の取得(途中から導入しても機能するように)
	//=============================================================================
	Game_System.prototype.backPictureName = function() {
	    if (!this._backPictureName && this._backPictureName !== '') {
	        this.initBackPictureName();
	    }
	    return this._backPictureName;
	};
	//=============================================================================
	// アクター選択ウィンドウ背景の初期化
	//=============================================================================
    Game_System.prototype.initWindowPictureName = function() {
        this._windowPictureName = Liquidize.Pon_MenuiPctureWindowPictureName;
    };
	//=============================================================================
	// アクター選択ウィンドウ背景の取得(途中から導入しても機能するように)
	//=============================================================================
	Game_System.prototype.windowPictureName = function() {
	    if (!this._windowPictureName && this._windowPictureName !== '') {
	        this.initWindowPictureName();
	    }
	    return this._windowPictureName;
	};
	//=============================================================================
	// アクターのセットアップにメニュー用立ち絵の追加
	//=============================================================================
    var _pon_gameactor_setup = Game_Actor.prototype.setup;
        Game_Actor.prototype.setup = function(actorId) {
        _pon_gameactor_setup.call(this, actorId);
        this.InitMenuStandPicture();
    };
	//=============================================================================
	// アクターのメニュー用立ち絵の初期化
	//=============================================================================
    Game_Actor.prototype.InitMenuStandPicture = function() {
        this._menuStandPicture = this.actor().meta.PonMenuStandPicture;
        this._standPictureFlag = true;
    };
	//=============================================================================
	// アクターのメニュー用立ち絵の取得(途中から導入しても機能するように)
	//=============================================================================
	Game_Actor.prototype.menuStandPicture = function() {
	    if (!this._standPictureFlag) {
	        this.InitMenuStandPicture();
	    }
	    return this._menuStandPicture;
	};
	//=============================================================================
	// アクターのメニュー用立ち絵の変更
	//=============================================================================
	Game_Actor.prototype.changeMenuStandPicture = function(filename) {
	    if (!this._standPictureFlag) {
	        this.InitMenuStandPicture();
	    }
	    this._menuStandPicture = filename;
	};
	//=============================================================================
	// メニューステータスウィンドウの初期化に背景ピクチャの処理を追加
	//=============================================================================
	var _pon_menustatus_initialize = Window_MenuStatus.prototype.initialize;
	Window_MenuStatus.prototype.initialize = function(x, y) {
	    _pon_menustatus_initialize.call(this, x, y);
	    if ($gameSystem.windowPictureName() !== '') {
	        this.createBackPicture();
	    }
	};
	//=============================================================================
	// アクターの顔グラの表示を立ち絵があった場合に立ち絵に変更
	//=============================================================================
	Window_MenuStatus.prototype.drawItemImage = function(index) {
        var actor = $gameParty.members()[index];
        var rect = this.itemRect(index);
        this.changePaintOpacity(actor.isBattleMember());
        if (actor.menuStandPicture()) {
          this.drawActorMenuStandPictureImage(actor,rect);
        }   else {
          this.drawActorFace(actor, rect.x + 1, rect.y + 1, Window_Base._faceWidth, Window_Base._faceHeight);
        }
        this.changePaintOpacity(true);
    };
	//=============================================================================
	// アクターのメニュー用立ち絵の描画
	//=============================================================================
    Window_MenuStatus.prototype.drawActorMenuStandPictureImage = function(actor,rect) {
        var bitmap = ImageManager.loadPicture(actor.menuStandPicture());
        var sx = 0;
        var sy = 0;
        var sw = Math.min(bitmap.width,rect.width);
        var sh = Math.min(bitmap.height,rect.height);
        var dx = rect.x;
        var dy = rect.y;
        this.contents.blt(bitmap, sx, sy, sw, sh, dx, dy);
    };
	//=============================================================================
	// ウィンドウの背景ピクチャの描画
	//=============================================================================
    Window_MenuStatus.prototype.createBackPicture = function() {
        this._backPictureSprite = new Sprite();
        this._backPictureSprite.bitmap = ImageManager.loadPicture($gameSystem.windowPictureName());
        this.addChildToBack(this._backPictureSprite);
        this._backPictureSprite.setFrame(0, 0, this.width, this.height);
    };
	//=============================================================================
	// 画面の背景にピクチャを追加
	//=============================================================================
	var _pon_menubasecreatebackground = Scene_MenuBase.prototype.createBackground;
    Scene_MenuBase.prototype.createBackground = function() {
        _pon_menubasecreatebackground.call(this);
        if (this._backPictuteFlag && $gameSystem.backPictureName() !== '') {
             this.createBackgroundPicture();
        }
    };
	//=============================================================================
	// 画面の背景のピクチャの作成
	//=============================================================================
    Scene_MenuBase.prototype.createBackgroundPicture = function() {
        this._backgroundPictureSprite = new Sprite();
        this._backgroundPictureSprite.bitmap = ImageManager.loadPicture($gameSystem.backPictureName());
        this.addChild(this._backgroundPictureSprite);
    };
	//=============================================================================
	// メニュー画面の背景のピクチャを表示するか設定
	//=============================================================================
    var _pon_menuinitialize = Scene_Menu.prototype.initialize;
    Scene_Menu.prototype.initialize = function() {
        _pon_menuinitialize.call(this);
        this._backPictuteFlag = Liquidize.Pon_MenuiPcture.MenuBackPicture;
        
    };
	//=============================================================================
	// アイテム画面の背景のピクチャを表示するか設定
	//=============================================================================
    var _pon_iteminitialize = Scene_Item.prototype.initialize;
    Scene_Item.prototype.initialize = function() {
        _pon_iteminitialize.call(this);
        this._backPictuteFlag = Liquidize.Pon_MenuiPcture.ItemBackPicture;
        
    };
	//=============================================================================
	// スキル画面の背景のピクチャを表示するか設定
	//=============================================================================
    var _pon_skillinitialize = Scene_Skill.prototype.initialize;
    Scene_Skill.prototype.initialize = function() {
        _pon_skillinitialize.call(this);
        this._backPictuteFlag = Liquidize.Pon_MenuiPcture.SkillBackPicture;
        
    };
	//=============================================================================
	// 装備画面の背景のピクチャを表示するか設定
	//=============================================================================
    var _pon_equipinitialize = Scene_Equip.prototype.initialize;
    Scene_Equip.prototype.initialize = function() {
        _pon_equipinitialize.call(this);
        this._backPictuteFlag = Liquidize.Pon_MenuiPcture.EquipBackPicture;
        
    };
	//=============================================================================
	// ステータス画面の背景のピクチャを表示するか設定
	//=============================================================================
    var _pon_statusinitialize = Scene_Status.prototype.initialize;
    Scene_Status.prototype.initialize = function() {
        _pon_statusinitialize.call(this);
        this._backPictuteFlag = Liquidize.Pon_MenuiPcture.StatusBackPicture;
        
    };
	//=============================================================================
	// セーブ画面の背景のピクチャを表示するか設定
	//=============================================================================
    var _pon_saveinitialize = Scene_Save.prototype.initialize;
    Scene_Save.prototype.initialize = function() {
        _pon_saveinitialize.call(this);
        this._backPictuteFlag = Liquidize.Pon_MenuiPcture.SaveBackPicture;
        
    };
	//=============================================================================
	// 終了画面の背景のピクチャを表示するか設定
	//=============================================================================
    var _pon_endinitialize = Scene_GameEnd.prototype.initialize;
    Scene_GameEnd.prototype.initialize = function() {
        _pon_endinitialize.call(this);
        this._backPictuteFlag = Liquidize.Pon_MenuiPcture.EndBackPicture;
        
    };
	//=============================================================================
	// オプション画面の背景のピクチャを表示するか設定
	//=============================================================================
    var _pon_optioninitialize = Scene_Options.prototype.initialize;
    Scene_Options.prototype.initialize = function() {
        _pon_optioninitialize.call(this);
        this._backPictuteFlag = Liquidize.Pon_MenuiPcture.OptionBackPicture;
        
    };

})();
 