//
//  アイテムにスキルタイプ付与 ver1.00
//
// author yana
//

var Imported = Imported || {};
Imported['ItemSkillType'] = 1.00;
/*:
 * @plugindesc ver1.00/アイテムにスキルタイプを関連付けることで、アイテムコマンドの封印などを可能にします。
 * @author Yana
 * 
 * @param ItemSkillType
 * @desc アイテムのスキルタイプとして設定するIDです。
 * @default 4
 * 
 * @help ------------------------------------------------------
 * 使用方法
 * ------------------------------------------------------
 * プラグインパラメータを設定すれば、動作します。
 * 
 * ------------------------------------------------------
 * 利用規約
 * ------------------------------------------------------ 
 * 使用に制限はありません。商用、アダルト、いずれにも使用できます。
 * 二次配布も制限はしませんが、サポートは行いません。
 * 著作表示は任意です。行わなくても利用できます。
 * 要するに、特に規約はありません。
 * バグ報告や使用方法等のお問合せはネ実ツクールスレ、または、Twitterにお願いします。
 * https://twitter.com/yanatsuki_
 * 素材利用は自己責任でお願いします。
 * ------------------------------------------------------
 * 更新履歴:
 * ver1.00:
 * 公開
 */
(function(){
	////////////////////////////////////////////////////////////////////////////////////
	
	var parameters = PluginManager.parameters('ItemSkillType');
	var itemSkillType = Number(parameters['ItemSkillType']);
	
	////////////////////////////////////////////////////////////////////////////////////
	
	// 再定義
	Window_ActorCommand.prototype.addItemCommand = function() {
    	this.addCommand(TextManager.item, 'item', !this._actor.isSkillTypeSealed(itemSkillType));
	};
	
	////////////////////////////////////////////////////////////////////////////////////
}());