/*:
@plugindesc 敵を倒したとき即座に経験値が入るシステム
@author うなぎおおとろ(twitter https://twitter.com/unagiootoro8388)

@help
敵を倒したとき即座に経験値が入るように変更するプラグインです。

[使い方]
このプラグインは導入するだけで使用できます。

[ライセンス]
このプラグインは、MITライセンスの条件の下で利用可能です。

v1.0.0 新規作成
*/
{
    const _BattleManager_initMembers = BattleManager.initMembers;
    BattleManager.initMembers = function() {
        _BattleManager_initMembers.call(this);
        this._deadEnemies = [];
    };

    BattleManager.processVictory = function() {
        $gameParty.removeBattleStates();
        $gameParty.performVictory();
        this.playVictoryMe();
        this.replayBgmAndBgs();
        this.displayVictoryMessage();
        this.endBattle(0);
    };

    BattleManager.makeRewards = function(members = $gameTroop.deadMembers()) {
        this._rewards = {};
        this._rewards.gold = $gameTroop.goldTotal(members);
        this._rewards.exp = $gameTroop.expTotal(members);
        this._rewards.items = $gameTroop.makeDropItems(members);
    };

    const _BattleManager_endAction = BattleManager.endAction;
    BattleManager.endAction = function() {
        _BattleManager_endAction.call(this);
        const turnDeadEnemies = $gameTroop.deadMembers().filter((enemy) => {
            return this._deadEnemies.indexOf(enemy) === -1;
        });
        this._deadEnemies = $gameTroop.deadMembers();
        this.makeRewards(turnDeadEnemies);
        this.displayRewards();
        this.gainRewards();
    };

    Game_Troop.prototype.expTotal = function(members = this.deadMembers()) {
        return members.reduce((r, enemy) => {
            return r + enemy.exp();
        }, 0);
    };
    
    Game_Troop.prototype.goldTotal = function(members = this.deadMembers()) {
        return members.reduce((r, enemy) => {
            return r + enemy.gold();
        }, 0) * this.goldRate();
    };

    Game_Troop.prototype.makeDropItems = function(members = this.deadMembers()) {
        return members.reduce((r, enemy) => {
            return r.concat(enemy.makeDropItems());
        }, []);
    };

}
