import DERObject from './DERObject';
import IssuerAndSerialNumber from './IssuerAndSerialNumber';
import AlgorithmIdentifier from './AlgorithmIdentifier';
import Attribute from './Attribute';
export default class SignerInfo implements DERObject {
    version: number;
    issuerAndSerialNumber: IssuerAndSerialNumber;
    digestAlgorithm: AlgorithmIdentifier;
    digestEncryptionAlgorithm: AlgorithmIdentifier;
    encryptedDigest: Uint8Array;
    authenticatedAttributes?: Attribute[] | undefined;
    unauthenticatedAttributes?: Attribute[] | undefined;
    constructor(version: number, issuerAndSerialNumber: IssuerAndSerialNumber, digestAlgorithm: AlgorithmIdentifier, digestEncryptionAlgorithm: AlgorithmIdentifier, encryptedDigest: Uint8Array, authenticatedAttributes?: Attribute[] | undefined, unauthenticatedAttributes?: Attribute[] | undefined);
    toDER(): number[];
}
